' 
' XCDR.BAS  11-26-94  Copyright 1994 by Matt Hart
'
' Enable custom mission support for the X-Wing Collectors CD
'
' Registered version
' 
' Compile and LINK with:
'
' C:\>bc XCDR /o;
' C:\>link /nod/noe/ex XCDR _noread _noerror _noval str01024,,nul,smalldos
'  pdq;
' C:\>exe2com XCDR
'
' Requires the Microsoft BASIC Compiler version 4.x, 6.x, 7.x, or
' Visual Basic/DOS 1.0 and the Crescent Software PDQ library.  VB/DOS or 7.x
' using /fs requires PDQ with far string support.
' 

DEFINT A-Z

'$INCLUDE: 'PDQDECL.BAS'
CONST False = 0
CONST True  = NOT False

DIM Registers AS RegType

ID$ = "XCDR X-Wing Collectors CD Custom Mission Support TSR"
PRINT
PRINT ID$                       'print it
PRINT
PRINT "Copyright 1994 by Matt E. Hart  CompuServe : 75450,3705"

C$ = UCASE$(LTRIM$(RTRIM$(COMMAND$)))
IF INSTR(C$,"?") OR INSTR(C$,"HELP") THEN
ShowHelp:
    PRINT
    PRINT " For use with LucasArt's X-Wing Collectors CD"
    PRINT
    PRINT " Syntax:"
    PRINT "        C:\> XCDR [drive] or [switches]"
    PRINT " {drive} = drive containing the \MISSION dir if using the original method"
    PRINT " [switches]"
    PRINT "      /f:{filename}"
    PRINT "         Path/filename to the text file containing the file substitutions"
    PRINT "         The substitutions must be in the same directory!"
    PRINT "      /u = Uninstall"
    PRINT " Example:
    PRINT "       C:\> XCDR c /f:c:\missions\darkk.xcd"
    PRINT
    END
ENDIF
DGroup = TSRInstalled%(ID$)     'see if we're already installed
IF DGroup THEN
    IF INSTR(C$,"/U") THEN
        Success1 = UnhookInt(Registers, DGroup)
        Success2 = DeinstallTSR(DGroup, ID$)
        IF Success1 AND Success2 THEN
            PRINT "XCDR removed"
        ELSE
            PRINT "Unable to remove XCDR.  Re-boot now!"
        ENDIF
    ELSE
        PRINT "XCDR already installed"
    ENDIF
    END
ELSEIF INSTR(C$,"/U") THEN
    PRINT "XCDR not installed"
    END
END IF
IF LEFT$(C$,3) = "/F:" THEN
    DatFile$ = MID$(C$,4)
    IF LEN(DIR$(DatFile$)) = 0 THEN
        PRINT "Error -> text file "+DatFile$+" not found!"
        GOTO ShowHelp
    ENDIF
    F=FREEFILE
    OPEN DatFile$ FOR INPUT AS F
    NFiles = 0
    DO UNTIL EOF(F)
        INPUT #F, A$
        IF EOF(F) THEN EXIT DO
        INPUT #F, A$
        NFiles = NFiles + 1
    LOOP
    IF NFiles = 0 THEN
        CLOSE F
        PRINT "Error -> text file "+DatFile$+" invalid!"
        GOTO ShowHelp
    ENDIF
    P$ = "" : LastBack = 0
    FOR i = 1 TO LEN(DatFile$)
        IF MID$(DatFile$,i,1) = "\" THEN LastBack = i
    NEXT
    P$ = LEFT$(DatFile$,LastBack)
    SEEK F,1
    DIM Files$(1 TO NFiles, 1 TO 2)
    NFiles = 0
    DO UNTIL EOF(F)
        NFiles = NFiles + 1
        INPUT #F, Files$(NFiles,1)
        IF EOF(F) THEN EXIT DO
        INPUT #F, A$
        Files$(NFiles,2) = P$ + A$
        IF LEN(DIR$(Files$(NFiles,2))) = 0 THEN
            PRINT "Error -> File ";Files$(NFiles,2);" not found!"
            CLOSE F
            GOTO ShowHelp
        ENDIF
    LOOP
    CLOSE F
ELSE
    D$ = C$ + ":\MISSION\*.*"
    NFiles = 0
    A$ = DIR$(D$)
    DO WHILE LEN(A$)
        NFiles = NFiles + 1
        A$ = DIR$
    LOOP
    IF NFiles = 0 THEN
        PRINT "Error -> no files found in "+D$
        GOTO ShowHelp
    ENDIF
    DIM Files$(1 TO NFiles,1 TO 2)
    NFiles = 0
    A$ = DIR$(D$)
    DO WHILE LEN(A$)
        NFiles = NFiles + 1
        Files$(NFiles,1) = A$
        Files$(NFiles,2) = C$+":\MISSION\"+A$
        A$ = DIR$
    LOOP
ENDIF
'  INTERRUPT 21h
'---- Trap Interrupt 21H, DOS services
Registers.IntNum = &H21             'specify trapping Int 21h
CALL PointIntHere(Registers)        'trap the interrupt
GOTO EndIt                          'skip past the Int 21h handler

CALL IntEntry1                      'we arrive here when an app calls for a key
CALL IntEntry2(Registers, Zero)     'these are the two mandatory calls

Service = Registers.AX \ 256

IF Service = &H3D THEN              ' Open file
    DEF SEG = Registers.DS
    ReqFile$ = ""
    FOR i = 0 TO 64
        Char = PEEK(Registers.DX + i)
        IF Char = 0 THEN EXIT FOR
        ReqFile$ = ReqFile$ + CHR$(Char)
    NEXT
    ReqFile$ = UCASE$(ReqFile$)
    FOR i = 1 TO NFiles
        IF INSTR(ReqFile$,Files$(i,1)) THEN
            FOR j = 0 TO LEN(Files$(i,2)) - 1
                POKE Registers.DX+j,ASC(MID$(Files$(i,2),j+1,1))
            NEXT
            POKE Registers.DX+j,0
            CALL PDQSound(800,1)
            EXIT FOR
        ENDIF
    NEXT
    DEF SEG
ENDIF

CALL GotoOldInt(Registers)      'continue on to the original Int 21h
' 
EndIt:
CALL EndTSR(ID$)                'terminate and stay resident
' 
